/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.platform;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import icyllis.modernui.platform.RenderCore;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class Bitmap
implements AutoCloseable {
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    @Nonnull
    private final Format mFormat;
    private final int mWidth;
    private final int mHeight;
    private long mPixels;
    private final boolean mFromSTB;

    public Bitmap(@Nonnull Format format, int width, int height, boolean init) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Bitmap size must be positive");
        }
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
        this.mFromSTB = false;
        long size = (long)format.channels() * (long)width * (long)height;
        this.mPixels = init ? MemoryUtil.nmemCallocChecked((long)1L, (long)size) : MemoryUtil.nmemAllocChecked((long)size);
    }

    private Bitmap(@Nonnull Format format, int width, int height, @Nonnull ByteBuffer data) throws IOException {
        if (data.capacity() != format.channels() * width * height) {
            throw new IOException("Not tightly packed");
        }
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
        this.mPixels = MemoryUtil.memAddress((ByteBuffer)data);
        this.mFromSTB = true;
    }

    @Nullable
    public static String getOpenDialog() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = SaveFormat.getAllFilters(stack);
            String string = TinyFileDialogs.tinyfd_openFileDialog(null, null, (PointerBuffer)filters, (CharSequence)SaveFormat.getAllDescription(), (boolean)false);
            return string;
        }
    }

    @Nullable
    public static String getSaveDialog(@Nonnull SaveFormat format) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filters = format.getFilters(stack);
            String string = TinyFileDialogs.tinyfd_saveFileDialog(null, (CharSequence)format.getFileName(), (PointerBuffer)filters, (CharSequence)format.getDescription());
            return string;
        }
    }

    @Nullable
    public static Bitmap openDialog(@Nullable Format format) throws IOException {
        String path = Bitmap.getOpenDialog();
        if (path != null) {
            try (FileInputStream stream = new FileInputStream(path);){
                Bitmap bitmap = Bitmap.decode(format, stream);
                return bitmap;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Bitmap decode(@Nullable Format format, @Nonnull InputStream stream) throws IOException {
        ByteBuffer buffer = null;
        try {
            buffer = RenderCore.readRawBuffer(stream);
            buffer.rewind();
            Bitmap bitmap = Bitmap.decode(format, buffer);
            return bitmap;
        }
        finally {
            if (buffer != null) {
                MemoryUtil.memFree((Buffer)buffer);
            }
        }
    }

    @Nonnull
    public static Bitmap decode(@Nullable Format format, @Nonnull ByteBuffer buffer) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            IntBuffer channels = stack.mallocInt(1);
            ByteBuffer data = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)(format == null ? 0 : format.channels()));
            if (data == null) {
                throw new IOException("Failed to read image: " + STBImage.stbi_failure_reason());
            }
            Bitmap bitmap = new Bitmap(format == null ? Format.of(channels.get(0)) : format, width.get(0), height.get(0), data);
            return bitmap;
        }
    }

    @Nonnull
    public Format getFormat() {
        return this.mFormat;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public long getPixels() {
        return this.mPixels;
    }

    public void saveDialog(@Nonnull SaveFormat format, int quality) throws IOException {
        String path = Bitmap.getSaveDialog(format);
        if (path != null) {
            this.saveToPath(Paths.get(path, new String[0]), format, quality);
        }
    }

    public void saveToPath(@Nonnull Path path, @Nonnull SaveFormat format, int quality) throws IOException {
        block14: {
            this.checkReleased();
            try (SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);){
                IOException[] exception = new IOException[1];
                try (STBIWriteCallback func = STBIWriteCallback.create((context, data, size) -> {
                    try {
                        channel.write(STBIWriteCallback.getData((long)data, (int)size));
                    }
                    catch (IOException e) {
                        exception[0] = e;
                    }
                });){
                    boolean success = format.write((Pointer)func, this.mWidth, this.mHeight, this.mFormat, this.mPixels, quality);
                    if (success) {
                        if (exception[0] != null) {
                            throw new IOException("An error occurred while saving image to the path \"" + path.toAbsolutePath() + "\"", exception[0]);
                        }
                        break block14;
                    }
                    throw new IOException("Failed to save image to the path \"" + path.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
                }
            }
        }
    }

    private void checkReleased() {
        if (this.mPixels == 0L) {
            throw new IllegalStateException("Cannot operate released bitmap");
        }
    }

    public void release() {
        if (this.mPixels != 0L) {
            if (this.mFromSTB) {
                STBImage.nstbi_image_free((long)this.mPixels);
            } else {
                MemoryUtil.nmemFree((long)this.mPixels);
            }
            this.mPixels = 0L;
        }
    }

    @Override
    public void close() throws Exception {
        this.release();
    }

    public static enum SaveFormat {
        PNG(new String[]{"*.png"}){

            @Override
            protected boolean write(@Nonnull Pointer func, int width, int height, @Nonnull Format format, long data, int quality) {
                return STBImageWrite.nstbi_write_png_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.channels(), (long)data, (int)0) != 0;
            }
        }
        ,
        TGA(new String[]{"*.tga", "*.vda", "*.icb", "*.vst"}){

            @Override
            protected boolean write(@Nonnull Pointer func, int width, int height, @Nonnull Format format, long data, int quality) {
                return STBImageWrite.nstbi_write_tga_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.channels(), (long)data) != 0;
            }
        }
        ,
        BMP(new String[]{"*.bmp", "*.dib"}){

            @Override
            protected boolean write(@Nonnull Pointer func, int width, int height, @Nonnull Format format, long data, int quality) {
                return STBImageWrite.nstbi_write_bmp_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.channels(), (long)data) != 0;
            }
        }
        ,
        JPEG(new String[]{"*.jpg", "*.jpeg", "*.jpe"}){

            @Override
            protected boolean write(@Nonnull Pointer func, int width, int height, @Nonnull Format format, long data, int quality) {
                if (quality < 1) {
                    quality = 1;
                } else if (quality > 120) {
                    quality = 120;
                }
                return STBImageWrite.nstbi_write_jpg_to_func((long)func.address(), (long)0L, (int)width, (int)height, (int)format.channels(), (long)data, (int)quality) != 0;
            }
        };

        @Nonnull
        private final String[] filters;

        private SaveFormat(String ... filters) {
            this.filters = filters;
        }

        protected boolean write(@Nonnull Pointer func, int width, int height, @Nonnull Format format, long data, int quality) throws IOException {
            throw new IOException("Unsupported save format");
        }

        @Nonnull
        private static PointerBuffer getAllFilters(@Nonnull MemoryStack stack) {
            int length = 0;
            for (SaveFormat format : SaveFormat.values()) {
                length += format.filters.length;
            }
            PointerBuffer buffer = stack.mallocPointer(length);
            for (SaveFormat format : SaveFormat.values()) {
                for (String filter : format.filters) {
                    stack.nUTF8Safe((CharSequence)filter, true);
                    buffer.put(stack.getPointerAddress());
                }
            }
            return (PointerBuffer)buffer.rewind();
        }

        @Nonnull
        private static String getAllDescription() {
            return "Images (" + Arrays.stream(SaveFormat.values()).flatMap(f -> Arrays.stream(f.filters)).sorted().collect(Collectors.joining(";")) + ")";
        }

        @Nonnull
        private PointerBuffer getFilters(@Nonnull MemoryStack stack) {
            PointerBuffer buffer = stack.mallocPointer(this.filters.length);
            for (String filter : this.filters) {
                stack.nUTF8Safe((CharSequence)filter, true);
                buffer.put(stack.getPointerAddress());
            }
            return (PointerBuffer)buffer.rewind();
        }

        @Nonnull
        private String getFileName() {
            return DATE_FORMAT.format(new Date()) + this.filters[0].substring(1);
        }

        @Nonnull
        private String getDescription() {
            return this.name() + " (" + String.join((CharSequence)", ", this.filters) + ")";
        }
    }

    public static enum Format {
        R(1),
        RG(2),
        RGB(3),
        RGBA(4);

        private final int channels;

        private Format(int channels) {
            this.channels = channels;
        }

        public final int channels() {
            return this.channels;
        }

        @Nonnull
        public static Format of(int channels) {
            if (channels < 1 || channels > 4) {
                throw new IllegalArgumentException("Specified channels ranged from 1 to 4");
            }
            return Format.values()[channels - 1];
        }
    }
}

